

-- architecture body --
library VITAL;
use VITAL.VITAL_Primitives.all;
library alt_vtl;
use alt_vtl.VTABLES.all;
architecture AltVITAL of TRIBUF is
   attribute VITAL_LEVEL1 of AltVITAL : architecture is TRUE;

   SIGNAL IN1_ipd	 : STD_LOGIC := 'X';
   SIGNAL OE_ipd	 : STD_LOGIC := 'X';

begin

   ---------------------
   --  INPUT PATH DELAYs
   ---------------------
   wire_delay : block
   begin
   VitalPropagateWireDelay (IN1_ipd, IN1, VitalExtendToFillDelay(tipd_IN1));
   VitalPropagateWireDelay (OE_ipd, OE, VitalExtendToFillDelay(tipd_OE));
   end block;
   --------------------
   --  BEHAVIOR SECTION
   --------------------
   VITALBehavior : process (IN1_ipd, OE_ipd)


   -- functionality results
   VARIABLE Results : STD_LOGIC_VECTOR(1 to 1) := (others => 'X');
   ALIAS Y_zd : STD_LOGIC is Results(1);

   -- output glitch detection variables
   VARIABLE Y_GlitchData	: GlitchDataType;

   begin

      -------------------------
      --  Functionality Section
      -------------------------
      Y_zd := VitalBUFIF0 (data => IN1_ipd,
              enable => (NOT OE_ipd));

      ----------------------
      --  Path Delay Section
      ----------------------
      VitalPropagatePathDelay (
       OutSignal => Y,
       OutSignalName => "Y",
       OutTemp => Y_zd,
       Paths => (0 => (IN1_ipd'last_event, VitalExtendToFillDelay(tpd_IN1_Y), TRUE),
                 1 => (OE_ipd'last_event, VitalExtendToFillDelay(tpd_OE_Y), TRUE)),
       GlitchData => Y_GlitchData,
       GlitchMode => MessageOnly,
       GlitchKind => On_Detect);


end process;

end AltVITAL;